<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Recibo de Pago</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 40px;
      font-size: 14px;
    }

    .recibo-container {
      max-width: 800px;
      margin: auto;
      border: 1px solid #000;
      padding: 20px;
    }

    .header {
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
    }

    .title {
      text-align: center;
      margin-top: 10px;
      font-weight: bold;
    }

    .info-empresa {
      font-size: 13px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }

    table, th, td {
      border: 1px solid #000;
    }

    th, td {
      padding: 6px;
      text-align: left;
    }

    .no-border {
      border: none;
    }

    .right {
      text-align: right;
    }

    .detalle-pago td {
      border: none;
      padding: 4px;
    }

    .footer-line {
      border-top: 1px solid black;
      margin-top: 40px;
    }
  </style>
</head>
<body>
  <div class="recibo-container">
    <div class="header">
      <div class="info-empresa">
        <strong>PhotoStore / Diego Sandoval</strong><br>
        Dir: Bartolo la Pampa, Av. La Paz y Potosí<br>
        Cel: +591 7299 3550 / 7299 1362<br>
        Correo: fotografiatarija@gmail.com
      </div>
      <div class="title">
        <h2>Recibo de Pago</h2>
        <p><strong>Número de Recibo:</strong> <?php echo e($venta['id']); ?></p>
      </div>
    </div>

    <table>
      <tr>
        <th>Fecha</th>
        <th>Nombre del cliente</th>
        <th>Teléfono</th>
        <th>Sucursal</th>
      </tr>
      <tr>
        <td><?php echo e(\Carbon\Carbon::parse($venta['fecha'])->format('Y-m-d')); ?></td>
        <td><?php echo e($venta['cliente']['nombre']); ?> <?php echo e($venta['cliente']['apellido']); ?></td>
        <td><?php echo e($venta['cliente']['telefono']); ?></td>
        <td><?php echo e($venta['sucursal']['lugar']); ?></td>
      </tr>
    </table>

    <table>
      <tr>
        <th>ID</th>
        <th>Producto</th>
        <th>Cant.</th>
        <th>Precio Unitario</th>
        <th>Total</th>
      </tr>
      <?php $__currentLoopData = $venta['detalle_venta_productos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <tr>
        <td><?php echo e($producto['id']); ?></td>
        <td><?php echo e($producto['nombreProducto']); ?></td>
        <td><?php echo e($producto['cantidad']); ?></td>
        <td><?php echo e(number_format($producto['precio'], 2)); ?></td>
        <td><?php echo e(number_format($producto['precioDetalle'], 2)); ?></td>
      </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>

    <?php
      $subtotal = array_sum(array_column($venta['detalle_venta_productos'], 'precioDetalle'));
      $descuento = $venta['precioProducto'] - $venta['precioTotal'];
      $aCuenta = $venta['precioTotal'] - $venta['saldo'];
      $entrega = $aCuenta - $venta['saldo'];
    ?>

    <table class="detalle-pago">
      <tr>
        <td><strong>A cuenta</strong></td>
        <td><?php echo e(number_format($aCuenta, 2)); ?></td>
        <td class="right"><strong>Sub Total</strong></td>
        <td><?php echo e(number_format($subtotal, 2)); ?></td>
      </tr>
      <tr>
        <td><strong>Saldo</strong></td>
        <td><?php echo e(number_format($venta['saldo'], 2)); ?></td>
        <td class="right"><strong>Descuento</strong></td>
        <td><?php echo e(number_format($descuento, 2)); ?></td>
      </tr>
      <tr>
        <td><strong>Entrega</strong></td>
        <td><?php echo e(number_format($entrega, 2)); ?></td>
        <td class="right"><strong>Total</strong></td>
        <td><?php echo e(number_format($venta['precioTotal'], 2)); ?></td>
      </tr>
    </table>

    <div class="footer-line"></div>
  </div>
</body>
</html>
<?php /**PATH D:\programacion\photo_store\photostore\resources\views/pdf/recibo.blade.php ENDPATH**/ ?>